/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.input.mapping;

import dev.isxander.controlify.controller.impl.ControllerStateImpl;
import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.mapping.MappingEntry;
import dev.isxander.controlify.controller.input.mapping.StateMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_2960;

public record ControllerMapping(List<MappingEntry> mappings, LinkedHashMap<class_2960, DeadzoneGroup> deadzones) implements StateMapper
{
    public static final ControllerMapping NO_MAPPING = new Builder().build();

    @Override
    public ControllerState mapState(ControllerState state) {
        if (this.mappings.isEmpty()) {
            return state;
        }
        ControllerStateImpl newState = new ControllerStateImpl();
        for (MappingEntry mapping : this.mappings) {
            mapping.apply(state, newState);
        }
        return newState;
    }

    public static class Builder {
        private final List<MappingEntry> mappings = new ArrayList<MappingEntry>();
        private final LinkedHashMap<class_2960, DeadzoneGroup> deadzones = new LinkedHashMap();

        public Builder putMapping(MappingEntry mapping) {
            if (mapping == null) {
                return this;
            }
            this.mappings.add(mapping);
            return this;
        }

        public Builder putDeadzoneGroups(Iterable<DeadzoneGroup> deadzoneGroup) {
            for (DeadzoneGroup group : deadzoneGroup) {
                this.deadzones.put(group.name(), group);
            }
            return this;
        }

        public ControllerMapping build() {
            return new ControllerMapping(this.mappings, this.deadzones);
        }
    }
}

