/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl.dualsense;

import dev.isxander.controlify.driver.sdl.dualsense.DS5EffectsState;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface DualsenseTriggerEffect {
    public DS5EffectsState.TriggerEffect createState();

    public record VibrationMultiplePosition(byte frequency, @Range(from=0L, to=8L) byte @NotNull [] amplitude) implements DualsenseTriggerEffect
    {
        public VibrationMultiplePosition(byte frequency, @Range(from=0L, to=8L) byte[] amplitude) {
            Validate.notNull((Object)amplitude, (String)"Amplitude array must not be null", (Object[])new Object[0]);
            Validate.isTrue((amplitude.length == 10 ? 1 : 0) != 0, (String)"Amplitude array must have 10 elements", (Object[])new Object[0]);
        }

        @Override
        public DS5EffectsState.TriggerEffect createState() {
            if (this.frequency > 0) {
                boolean allZero = true;
                for (int i = 0; i < 10; ++i) {
                    allZero &= this.amplitude[i] == 0;
                    Validate.inclusiveBetween((long)0L, (long)8L, (long)this.amplitude[i], (String)"Amplitude i=%s must be between 0 and 8 inclusive".formatted(i));
                }
                if (!allZero) {
                    int strengthZones = 0;
                    int activeZones = 0;
                    for (int i = 0; i < 10; ++i) {
                        byte amplitudeValue = this.amplitude[i];
                        if (amplitudeValue <= 0) continue;
                        byte strengthValue = (byte)(amplitudeValue - 1 & 7);
                        strengthZones |= strengthValue << 3 * i;
                        activeZones = (char)(activeZones | (char)(1 << i));
                    }
                    return new DS5EffectsState.TriggerEffect(38, new byte[]{(byte)(activeZones & 0xFF), (byte)(activeZones >> 8 & 0xFF), (byte)(strengthZones & 0xFF), (byte)(strengthZones >> 8 & 0xFF), (byte)(strengthZones >> 16 & 0xFF), (byte)(strengthZones >> 24 & 0xFF), 0, 0, this.frequency});
                }
            }
            return DS5EffectsState.TriggerEffect.OFF;
        }
    }

    public record FeedbackSlope(@Range(from=0L, to=8L) byte startPosition, @Range(from=1L, to=9L) byte endPosition, @Range(from=1L, to=8L) byte startStrength, @Range(from=1L, to=8L) byte endStrength) implements DualsenseTriggerEffect
    {
        public FeedbackSlope(@Range(from=0L, to=8L) byte startPosition, @Range(from=1L, to=9L) byte endPosition, @Range(from=1L, to=8L) byte startStrength, @Range(from=1L, to=8L) byte endStrength) {
            Validate.inclusiveBetween((long)0L, (long)8L, (long)startPosition, (String)"Start position must be between 0 and 8 inclusive");
            Validate.inclusiveBetween((long)(startPosition + 1), (long)9L, (long)endPosition, (String)"End position must be between start+1 and 9 inclusive");
            Validate.inclusiveBetween((long)1L, (long)8L, (long)startStrength, (String)"Start strength must be between 1 and 8 inclusive");
            Validate.inclusiveBetween((long)1L, (long)8L, (long)endStrength, (String)"End strength must be between 1 and 8 inclusive");
            Validate.isTrue((startPosition < endPosition ? 1 : 0) != 0, (String)"Start strength must be less than end position", (Object[])new Object[0]);
        }

        @Override
        public DS5EffectsState.TriggerEffect createState() {
            byte[] strength = new byte[10];
            float gradient = (float)(this.endStrength - this.startStrength) / (float)(this.endPosition - this.startPosition);
            for (int i = this.startPosition; i < 10; ++i) {
                strength[i] = i <= this.endPosition ? (byte)Math.round((float)this.startStrength + gradient * (float)(i - this.startPosition)) : this.endStrength;
            }
            return new FeedbackMultiplePosition(strength).createState();
        }
    }

    public record FeedbackMultiplePosition(@Range(from=0L, to=9L) byte @NotNull [] strength) implements DualsenseTriggerEffect
    {
        public FeedbackMultiplePosition(@Range(from=0L, to=9L) byte[] strength) {
            Validate.notNull((Object)strength, (String)"Strength array must not be null", (Object[])new Object[0]);
            Validate.isTrue((strength.length == 10 ? 1 : 0) != 0, (String)"Strength array must have 10 elements", (Object[])new Object[0]);
        }

        @Override
        public DS5EffectsState.TriggerEffect createState() {
            boolean allZero = true;
            for (int i = 0; i < 10; ++i) {
                allZero &= this.strength[i] == 0;
                Validate.inclusiveBetween((long)0L, (long)8L, (long)this.strength[i], (String)"Strength i=%s must be between 0 and 8 inclusive".formatted(i));
            }
            if (!allZero) {
                int forceZones = 0;
                int activeZones = 0;
                for (int i = 0; i < 10; ++i) {
                    byte strengthValue = this.strength[i];
                    if (strengthValue <= 0) continue;
                    byte forceValue = (byte)(strengthValue - 1 & 7);
                    forceZones |= forceValue << 3 * i;
                    activeZones = (char)(activeZones | (char)(1 << i));
                }
                return new DS5EffectsState.TriggerEffect(33, new byte[]{(byte)(activeZones & 0xFF), (byte)(activeZones >> 8 & 0xFF), (byte)(forceZones & 0xFF), (byte)(forceZones >> 8 & 0xFF), (byte)(forceZones >> 16 & 0xFF), (byte)(forceZones >> 24 & 0xFF)});
            }
            return DS5EffectsState.TriggerEffect.OFF;
        }
    }

    public record Vibration(@Range(from=0L, to=9L) byte position, @Range(from=0L, to=8L) byte amplitude, byte frequency) implements DualsenseTriggerEffect
    {
        public Vibration(@Range(from=0L, to=9L) byte position, @Range(from=0L, to=8L) byte amplitude, byte frequency) {
            Validate.inclusiveBetween((long)0L, (long)9L, (long)position, (String)"Position must be between 0 and 9 inclusive");
            Validate.inclusiveBetween((long)0L, (long)8L, (long)amplitude, (String)"Amplitude must be between 0 and 8 inclusive");
        }

        @Override
        public DS5EffectsState.TriggerEffect createState() {
            if (this.amplitude > 0 && this.frequency > 0) {
                byte strengthValue = (byte)(this.amplitude - 1 & 7);
                int amplitudeZones = 0;
                int activeZones = 0;
                for (int i = this.position; i < 10; ++i) {
                    amplitudeZones |= strengthValue << 3 * i;
                    activeZones = (char)(activeZones | (char)(1 << i));
                }
                return new DS5EffectsState.TriggerEffect(38, new byte[]{(byte)(activeZones & 0xFF), (byte)(activeZones >> 8 & 0xFF), (byte)(amplitudeZones & 0xFF), (byte)(amplitudeZones >> 8 & 0xFF), (byte)(amplitudeZones >> 16 & 0xFF), (byte)(amplitudeZones >> 24 & 0xFF), 0, 0, this.frequency});
            }
            return DS5EffectsState.TriggerEffect.OFF;
        }
    }

    public record Weapon(@Range(from=2L, to=7L) byte startPosition, @Range(from=3L, to=8L) byte endPosition, @Range(from=0L, to=8L) byte strength) implements DualsenseTriggerEffect
    {
        public Weapon(@Range(from=2L, to=7L) byte startPosition, @Range(from=3L, to=8L) byte endPosition, @Range(from=0L, to=8L) byte strength) {
            Validate.inclusiveBetween((long)2L, (long)7L, (long)startPosition, (String)"Start position must be between 2 and 7 inclusive");
            Validate.inclusiveBetween((long)(startPosition + 1), (long)8L, (long)endPosition, (String)"End position must be between start+1 and 8 inclusive");
            Validate.inclusiveBetween((long)0L, (long)8L, (long)strength, (String)"Strength must be between 0 and 8 inclusive");
            Validate.isTrue((startPosition < endPosition ? 1 : 0) != 0, (String)"Start position must be less than end position", (Object[])new Object[0]);
        }

        @Override
        public DS5EffectsState.TriggerEffect createState() {
            if (this.strength > 0) {
                char startAndStopZones = (char)(1 << this.startPosition | 1 << this.endPosition);
                return new DS5EffectsState.TriggerEffect(37, new byte[]{(byte)(startAndStopZones & 0xFF), (byte)(startAndStopZones >> 8 & 0xFF), (byte)(this.strength - 1)});
            }
            return DS5EffectsState.TriggerEffect.OFF;
        }
    }

    public record Feedback(@Range(from=0L, to=9L) byte position, @Range(from=0L, to=8L) byte strength) implements DualsenseTriggerEffect
    {
        public Feedback(@Range(from=0L, to=9L) byte position, @Range(from=0L, to=8L) byte strength) {
            Validate.inclusiveBetween((long)0L, (long)9L, (long)position, (String)"Position must be between 0 and 9 inclusive");
            Validate.inclusiveBetween((long)0L, (long)8L, (long)strength, (String)"Strength must be between 0 and 8 inclusive");
        }

        @Override
        public DS5EffectsState.TriggerEffect createState() {
            if (this.strength > 0) {
                byte forceValue = (byte)(this.strength - 1 & 7);
                int forceZones = 0;
                int activeZones = 0;
                for (int i = this.position; i < 10; ++i) {
                    forceZones |= forceValue << 3 * i;
                    activeZones = (char)(activeZones | (char)(1 << i));
                }
                return new DS5EffectsState.TriggerEffect(33, new byte[]{(byte)(activeZones & 0xFF), (byte)(activeZones >> 8 & 0xFF), (byte)(forceZones & 0xFF), (byte)(forceZones >> 8 & 0xFF), (byte)(forceZones >> 16 & 0xFF), (byte)(forceZones >> 24 & 0xFF)});
            }
            return DS5EffectsState.TriggerEffect.OFF;
        }
    }

    public record Off() implements DualsenseTriggerEffect
    {
        @Override
        public DS5EffectsState.TriggerEffect createState() {
            return DS5EffectsState.TriggerEffect.OFF;
        }
    }
}

