/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.gyro.GyroState;
import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.utils.ClientUtils;
import dev.isxander.controlify.utils.render.CGuiPose;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5489;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ControllerCalibrationScreen
extends class_437
implements DontInteruptScreen {
    private static final int CALIBRATION_TIME = 100;
    protected final Controlify controlify;
    protected final ControllerManager controllerManager;
    protected final ControllerEntity controller;
    private final Supplier<class_437> parent;
    private class_5489 waitLabel;
    private class_5489 infoLabel;
    private class_5489 completeLabel;
    protected class_4185 readyButton;
    protected class_4185 laterButton;
    protected boolean calibrating = false;
    protected boolean calibrated = false;
    protected int calibrationTicks = 0;
    @Nullable
    private final Map<class_2960, float[]> axisData;
    private GyroState accumulatedGyroVelocity = new GyroState();

    public ControllerCalibrationScreen(ControllerEntity controller, class_437 parent) {
        this(controller, () -> parent);
    }

    public ControllerCalibrationScreen(ControllerEntity controller, Supplier<class_437> parent) {
        super((class_2561)class_2561.method_43471((String)"controlify.calibration.title"));
        this.controlify = Controlify.instance();
        this.controllerManager = this.controlify.getControllerManager().orElseThrow();
        this.controller = controller;
        this.parent = parent;
        Optional<InputComponent> inputOpt = controller.input();
        this.axisData = inputOpt.map(inputComponent -> new HashMap(inputComponent.axisCount())).orElse(null);
    }

    protected void method_25426() {
        this.readyButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"controlify.calibration.ready"), btn -> this.onButtonPress()).method_46432(150).method_46433(this.field_22789 / 2 - 150 - 5, this.field_22790 - 8 - 20).method_46431();
        this.method_37063((class_364)this.readyButton);
        this.laterButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"controlify.calibration.later"), btn -> this.onLaterButtonPress()).method_46432(150).method_46433(this.field_22789 / 2 + 5, this.field_22790 - 8 - 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"controlify.calibration.later.tooltip"))).method_46431();
        this.method_37063((class_364)this.laterButton);
        this.infoLabel = class_5489.method_30890((class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"controlify.calibration.info"), (int)(this.field_22789 - 30));
        this.waitLabel = class_5489.method_30890((class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"controlify.calibration.wait"), (int)(this.field_22789 - 30));
        this.completeLabel = class_5489.method_30890((class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"controlify.calibration.complete"), (int)(this.field_22789 - 30));
    }

    protected void startCalibration() {
        this.calibrating = true;
        this.readyButton.field_22763 = false;
        this.readyButton.method_25355((class_2561)class_2561.method_43471((String)"controlify.calibration.calibrating"));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"controlify.calibration.title", (Object[])new Object[]{this.controller.name()}).method_27692(class_124.field_1067), this.field_22789 / 2, 8, -1);
        CGuiPose pose = CGuiPose.ofPush(graphics);
        pose.scale(2.0f, 2.0f);
        float progress = ((float)(this.calibrationTicks - 1) + delta) / 100.0f;
        progress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
        ClientUtils.drawBar(graphics, this.field_22789 / 2 / 2, 15, progress);
        pose.pop();
        class_5489 label = this.calibrating ? this.waitLabel : (this.calibrated ? this.completeLabel : this.infoLabel);
        int anchorX = this.field_22789 / 2;
        int topY = 55;
        label.method_30888(graphics, anchorX, topY);
        pose.push();
        int n = this.readyButton.method_46427();
        Objects.requireNonNull(this.field_22793);
        float scale = Math.min(3.0f, (float)(n - (55 + 9 * label.method_30887()) - 2) / 64.0f);
        float f = (float)this.field_22789 / 2.0f - 32.0f * scale;
        Objects.requireNonNull(this.field_22793);
        pose.translate(f, 55 + 9 * label.method_30887());
        pose.scale(scale, scale);
        ClientUtils.drawSprite(graphics, this.controller.info().type().getIconSprite(), 0, 0, 64, 64);
        pose.pop();
    }

    public void method_25393() {
        if (!this.controllerManager.isControllerConnected(this.controller.uid())) {
            this.method_25419();
            return;
        }
        if (!this.calibrating) {
            return;
        }
        if (this.stateChanged()) {
            this.calibrationTicks = 0;
            if (this.axisData != null) {
                this.axisData.clear();
            }
            this.accumulatedGyroVelocity = new GyroState();
        }
        if (this.calibrationTicks < 100) {
            this.processAxisData(this.calibrationTicks);
            this.processGyroData();
            ++this.calibrationTicks;
        } else {
            this.calibrateAxis();
            this.generateGyroCalibration();
            this.calibrating = false;
            this.calibrated = true;
            this.readyButton.field_22763 = true;
            this.readyButton.method_25355((class_2561)class_2561.method_43471((String)"controlify.calibration.done"));
            this.controller.input().map(input -> input.config().config()).ifPresent(config -> {
                config.deadzonesCalibrated = true;
                config.delayedCalibration = false;
            });
            this.controller.gyro().map(gyro -> gyro.config().config()).ifPresent(config -> {
                config.calibrated = true;
            });
            Controlify.instance().config().setDirty();
            Controlify.instance().config().saveIfDirty();
        }
    }

    private void processAxisData(int tick) {
        if (this.axisData == null) {
            return;
        }
        InputComponent input = this.controller.input().orElseThrow();
        ControllerState state = input.rawStateNow();
        for (DeadzoneGroup group : input.getDeadzoneGroups().values()) {
            float[] axisData = this.axisData.computeIfAbsent(group.name(), k -> new float[100]);
            float max = 0.0f;
            for (class_2960 axis : group.axes()) {
                max = Math.max(max, Math.abs(state.getAxisState(axis)));
            }
            axisData[tick] = max;
        }
    }

    private void processGyroData() {
        this.controller.gyro().ifPresent(gyro -> this.accumulatedGyroVelocity.add(gyro.getState()));
    }

    private void calibrateAxis() {
        if (this.axisData == null) {
            return;
        }
        InputComponent input = this.controller.input().orElseThrow();
        input.config().config().deadzones.clear();
        for (DeadzoneGroup group : input.getDeadzoneGroups().values()) {
            float[] axisData = this.axisData.get(group.name());
            if (axisData == null) continue;
            float maxAbs = 0.0f;
            for (int tick = 0; tick < 100; ++tick) {
                float axisValue = axisData[tick];
                maxAbs = Math.max(maxAbs, Math.abs(axisValue));
            }
            input.config().config().deadzones.put(group.name(), Float.valueOf(maxAbs + 0.08f));
        }
    }

    private void generateGyroCalibration() {
        this.controller.gyro().ifPresent(gyro -> {
            gyro.config().config().calibration = this.accumulatedGyroVelocity.div(100.0f);
        });
    }

    private boolean stateChanged() {
        InputComponent input = this.controller.input().orElseThrow();
        float amt = 0.4f;
        for (class_2960 axis : input.rawStateNow().getAxes()) {
            float prevAxisValue;
            float axisValue;
            float[] axisData = this.axisData.get(axis);
            if (axisData == null || !(Math.abs((axisValue = input.rawStateNow().getAxisState(axis)) - (prevAxisValue = input.rawStateThen().getAxisState(axis))) > amt)) continue;
            return true;
        }
        return false;
    }

    private void onButtonPress() {
        if (!this.calibrated) {
            this.startCalibration();
            this.method_37066((class_364)this.laterButton);
            this.readyButton.method_46421(this.field_22789 / 2 - 75);
        } else {
            this.method_25419();
        }
    }

    private void onLaterButtonPress() {
        if (!this.calibrated) {
            boolean dirty = false;
            dirty |= this.controller.input().map(input -> {
                input.config().config().delayedCalibration = true;
                return true;
            }).orElse(false).booleanValue();
            if (dirty |= this.controller.gyro().map(gyro -> {
                gyro.config().config().delayedCalibration = true;
                return true;
            }).orElse(false).booleanValue()) {
                Controlify.instance().config().setDirty();
            }
            this.method_25419();
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent.get());
    }

    public boolean method_25422() {
        return false;
    }
}

