/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.haptic.HapticEffects;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.mixins.feature.screenop.ScreenAccessor;
import dev.isxander.controlify.mixins.feature.screenop.impl.outofgame.TabNavigationBarAccessor;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ComponentProcessorProvider;
import dev.isxander.controlify.screenop.CustomFocus;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.keyboard.ComponentKeyboardBehaviour;
import dev.isxander.controlify.screenop.keyboard.InputTarget;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayoutWithId;
import dev.isxander.controlify.screenop.keyboard.KeyboardOverlayScreen;
import dev.isxander.controlify.sound.ControlifyClientSounds;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_8015;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8028;
import net.minecraft.class_8087;
import net.minecraft.class_8089;
import org.jetbrains.annotations.Nullable;

public class ScreenProcessor<T extends class_437> {
    public final T screen;
    protected final HoldRepeatHelper holdRepeatHelper;
    protected static final class_310 minecraft = class_310.method_1551();
    private final List<ScreenControllerEventListener> eventListeners = new ArrayList<ScreenControllerEventListener>();

    public ScreenProcessor(T screen) {
        this.screen = screen;
        if (screen instanceof ScreenControllerEventListener) {
            ScreenControllerEventListener eventListener = (ScreenControllerEventListener)screen;
            this.eventListeners.add(eventListener);
        }
        this.holdRepeatHelper = this.createHoldRepeatHelper();
    }

    public void onControllerUpdate(ControllerEntity controller) {
        Controlify.instance().virtualMouseHandler().handleControllerInput(controller);
        if (!Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled()) {
            if (!this.handleComponentNavOverride(controller)) {
                this.handleComponentNavigation(controller);
            }
            if (!this.handleComponentButtonOverride(controller)) {
                this.handleButtons(controller);
            }
        } else {
            this.handleScreenVMouse(controller, Controlify.instance().virtualMouseHandler());
        }
        this.handleTabNavigation(controller);
        this.eventListeners.forEach(listener -> listener.onControllerInput(controller));
    }

    public void render(ControllerEntity controller, class_332 graphics, float tickDelta) {
        VirtualMouseHandler vmouse = Controlify.instance().virtualMouseHandler();
        this.render(controller, graphics, tickDelta, vmouse.isVirtualMouseEnabled() ? Optional.of(vmouse) : Optional.empty());
    }

    public void onInputModeChanged(InputMode mode) {
        switch (mode) {
            case KEYBOARD_MOUSE: {
                boolean shouldKeepFocus = this.getFocusTree().stream().anyMatch(component -> ComponentProcessorProvider.provide(component).shouldKeepFocusOnKeyboardMode(this));
                if (shouldKeepFocus) break;
                ((ScreenAccessor)this.screen).invokeClearFocus();
                break;
            }
            case CONTROLLER: 
            case MIXED: {
                if (Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled()) break;
                ((ScreenAccessor)this.screen).invokeSetInitialFocus();
            }
        }
    }

    protected void handleComponentNavigation(ControllerEntity controller) {
        if (this.screen.method_25399() == null) {
            ((ScreenAccessor)this.screen).invokeSetInitialFocus();
        }
        List<class_364> focuses = List.copyOf(this.getFocusTree());
        boolean repeatEventAvailable = this.holdRepeatHelper.canNavigate();
        InputComponent input = controller.input().orElseThrow();
        ControllerStateView state = input.stateNow();
        ControllerStateView prevState = input.stateThen();
        InputBinding guiNaviRight = ControlifyBindings.GUI_NAVI_RIGHT.on(controller);
        InputBinding guiNaviLeft = ControlifyBindings.GUI_NAVI_LEFT.on(controller);
        InputBinding guiNaviUp = ControlifyBindings.GUI_NAVI_UP.on(controller);
        InputBinding guiNaviDown = ControlifyBindings.GUI_NAVI_DOWN.on(controller);
        Supplier<Boolean> navigationFunc = null;
        if (guiNaviRight.digitalNow() && (repeatEventAvailable || !guiNaviRight.digitalPrev())) {
            navigationFunc = this.createScreenNavigationFunc(class_8028.field_41829);
            if (!guiNaviRight.digitalPrev()) {
                this.holdRepeatHelper.reset();
            }
        } else if (guiNaviLeft.digitalNow() && (repeatEventAvailable || !guiNaviLeft.digitalPrev())) {
            navigationFunc = this.createScreenNavigationFunc(class_8028.field_41828);
            if (!guiNaviLeft.digitalPrev()) {
                this.holdRepeatHelper.reset();
            }
        } else if (guiNaviUp.digitalNow() && (repeatEventAvailable || !guiNaviUp.digitalPrev())) {
            navigationFunc = this.createScreenNavigationFunc(class_8028.field_41826);
            if (!guiNaviUp.digitalPrev()) {
                this.holdRepeatHelper.reset();
            }
        } else if (guiNaviDown.digitalNow() && (repeatEventAvailable || !guiNaviDown.digitalPrev())) {
            navigationFunc = this.createScreenNavigationFunc(class_8028.field_41827);
            if (!guiNaviDown.digitalPrev()) {
                this.holdRepeatHelper.reset();
            }
        } else if (state.isButtonDown(GamepadInputs.DPAD_RIGHT_BUTTON) && (repeatEventAvailable || !prevState.isButtonDown(GamepadInputs.DPAD_RIGHT_BUTTON))) {
            navigationFunc = this.createScreenNavigationFunc(class_8028.field_41829);
            if (!prevState.isButtonDown(GamepadInputs.DPAD_RIGHT_BUTTON)) {
                this.holdRepeatHelper.reset();
            }
        } else if (state.isButtonDown(GamepadInputs.DPAD_LEFT_BUTTON) && (repeatEventAvailable || !prevState.isButtonDown(GamepadInputs.DPAD_LEFT_BUTTON))) {
            navigationFunc = this.createScreenNavigationFunc(class_8028.field_41828);
            if (!prevState.isButtonDown(GamepadInputs.DPAD_LEFT_BUTTON)) {
                this.holdRepeatHelper.reset();
            }
        } else if (state.isButtonDown(GamepadInputs.DPAD_UP_BUTTON) && (repeatEventAvailable || !prevState.isButtonDown(GamepadInputs.DPAD_UP_BUTTON))) {
            navigationFunc = this.createScreenNavigationFunc(class_8028.field_41826);
            if (!prevState.isButtonDown(GamepadInputs.DPAD_UP_BUTTON)) {
                this.holdRepeatHelper.reset();
            }
        } else if (state.isButtonDown(GamepadInputs.DPAD_DOWN_BUTTON) && (repeatEventAvailable || !prevState.isButtonDown(GamepadInputs.DPAD_DOWN_BUTTON))) {
            navigationFunc = this.createScreenNavigationFunc(class_8028.field_41827);
            if (!prevState.isButtonDown(GamepadInputs.DPAD_DOWN_BUTTON)) {
                this.holdRepeatHelper.reset();
            }
        }
        if (navigationFunc != null && navigationFunc.get().booleanValue()) {
            this.holdRepeatHelper.onNavigate();
            controller.input().ifPresent(InputComponent::notifyGuiPressOutputsOfNavigate);
            if (Controlify.instance().config().globalSettings().extraUiSounds) {
                ScreenProcessor.playFocusChangeSound();
            }
            controller.hdHaptics().ifPresent(haptics -> haptics.playHaptic(HapticEffects.NAVIGATE));
            Queue<class_364> newFocusTree = this.getFocusTree();
            while (!newFocusTree.isEmpty() && !focuses.contains(newFocusTree.peek())) {
                ComponentProcessorProvider.provide(newFocusTree.poll()).onFocusGained(this, controller);
            }
        }
    }

    @Nullable
    protected Supplier<Boolean> createScreenNavigationFunc(class_8028 direction) {
        class_8023.class_8024 event = new class_8023.class_8024(direction);
        class_8016 path = this.screen.method_48205((class_8023)event);
        if (path == null) {
            return null;
        }
        return () -> {
            ((ScreenAccessor)this.screen).invokeChangeFocus(path);
            return true;
        };
    }

    protected void handleButtons(ControllerEntity controller) {
        boolean vmouseEnabled = Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled();
        InputComponent input = controller.input().orElseThrow();
        boolean touchpadPressed = input.stateNow().isButtonDown(GamepadInputs.TOUCHPAD_1_BUTTON);
        boolean prevTouchpadPressed = input.stateThen().isButtonDown(GamepadInputs.TOUCHPAD_1_BUTTON);
        if ((ControlifyBindings.GUI_PRESS.on(controller).guiPressed().get() || vmouseEnabled && touchpadPressed && !prevTouchpadPressed) && !this.tryOpenKeyboard(controller, this.screen.method_25399())) {
            this.screen.method_25404(257, 0, 0);
        }
        if (this.screen.method_25422() && ControlifyBindings.GUI_BACK.on(controller).guiPressed().get()) {
            ScreenProcessor.playClackSound();
            this.screen.method_25419();
        }
    }

    protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
        class_310.method_1551().method_48185(class_8015.field_41778);
    }

    protected boolean handleComponentButtonOverride(ControllerEntity controller) {
        Queue<class_364> focusTree = this.getFocusTree();
        while (!focusTree.isEmpty()) {
            class_364 focused = focusTree.poll();
            ComponentProcessor processor = ComponentProcessorProvider.provide(focused);
            if (!processor.overrideControllerButtons(this, controller)) continue;
            return true;
        }
        return false;
    }

    protected boolean handleComponentNavOverride(ControllerEntity controller) {
        Queue<class_364> focusTree = this.getFocusTree();
        while (!focusTree.isEmpty()) {
            class_364 focused = focusTree.poll();
            ComponentProcessor processor = ComponentProcessorProvider.provide(focused);
            if (!processor.overrideControllerNavigation(this, controller)) continue;
            return true;
        }
        return false;
    }

    protected void handleTabNavigation(ControllerEntity controller) {
        block3: {
            boolean prevTab;
            block2: {
                boolean nextTab = ControlifyBindings.GUI_NEXT_TAB.on(controller).justPressed();
                prevTab = ControlifyBindings.GUI_PREV_TAB.on(controller).justPressed();
                if (nextTab) break block2;
                if (!prevTab) break block3;
            }
            this.screen.method_25396().stream().filter(child -> child instanceof class_8089).map(class_8089.class::cast).findAny().ifPresent(navBar -> {
                TabNavigationBarAccessor accessor = (TabNavigationBarAccessor)navBar;
                ImmutableList<class_8087> tabs = accessor.getTabs();
                int currentIndex = tabs.indexOf(accessor.getTabManager().method_48614());
                int newIndex = currentIndex + (prevTab ? -1 : 1);
                if (newIndex < 0) {
                    newIndex = tabs.size() - 1;
                }
                if (newIndex >= tabs.size()) {
                    newIndex = 0;
                }
                navBar.method_48987(newIndex, true);
                this.onTabChanged(controller);
            });
        }
    }

    protected void onTabChanged(ControllerEntity controller) {
    }

    public void onWidgetRebuild() {
        if (Controlify.instance().currentInputMode().isController() && !Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled()) {
            minecraft.method_48185(class_8015.field_43097);
        }
    }

    public void onVirtualMouseToggled(boolean enabled) {
        if (enabled) {
            ((ScreenAccessor)this.screen).invokeClearFocus();
        } else {
            ((ScreenAccessor)this.screen).invokeSetInitialFocus();
        }
    }

    protected void render(ControllerEntity controller, class_332 graphics, float tickDelta, Optional<VirtualMouseHandler> vmouse) {
    }

    public VirtualMouseBehaviour virtualMouseBehaviour() {
        return VirtualMouseBehaviour.DEFAULT;
    }

    public void addEventListener(ScreenControllerEventListener listener) {
        this.eventListeners.add(listener);
    }

    public boolean tryOpenKeyboard(ControllerEntity controller, @Nullable class_364 element) {
        block9: {
            KeyboardLayoutWithId layout;
            Object object;
            ComponentKeyboardBehaviour behaviour;
            ComponentProcessor componentProcessor = ComponentProcessorProvider.provide(element);
            ComponentKeyboardBehaviour componentKeyboardBehaviour = behaviour = componentProcessor.getKeyboardBehaviour(this, controller);
            Objects.requireNonNull(componentKeyboardBehaviour);
            ComponentKeyboardBehaviour componentKeyboardBehaviour2 = componentKeyboardBehaviour;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComponentKeyboardBehaviour.DoNothing.class, ComponentKeyboardBehaviour.Undefined.class, ComponentKeyboardBehaviour.Handled.class}, (Object)componentKeyboardBehaviour2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ComponentKeyboardBehaviour.DoNothing doNothing = (ComponentKeyboardBehaviour.DoNothing)componentKeyboardBehaviour2;
                    return true;
                }
                case 1: {
                    ComponentKeyboardBehaviour.Undefined undefined = (ComponentKeyboardBehaviour.Undefined)componentKeyboardBehaviour2;
                    return false;
                }
                case 2: 
            }
            ComponentKeyboardBehaviour.Handled handled = (ComponentKeyboardBehaviour.Handled)componentKeyboardBehaviour2;
            try {
                object = handled.layout();
                layout = object;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object inputTarget = object = handled.inputTarget();
            Object positioner = object = handled.positioner();
            if (!controller.genericConfig().config().showOnScreenKeyboard) break block9;
            minecraft.method_1507((class_437)new KeyboardOverlayScreen((class_437)this.screen, layout, (InputTarget)inputTarget, (KeyboardOverlayScreen.KeyboardPositioner)positioner));
        }
        return true;
    }

    protected HoldRepeatHelper createHoldRepeatHelper() {
        return new HoldRepeatHelper(10, 3);
    }

    protected Queue<class_364> getFocusTree() {
        if (this.screen.method_25399() == null) {
            return new ArrayDeque<class_364>();
        }
        ArrayDeque<class_364> tree = new ArrayDeque<class_364>();
        class_364 focused = this.screen.method_25399();
        tree.add(focused);
        while (focused instanceof CustomFocus) {
            CustomFocus customFocus = (CustomFocus)focused;
            if ((focused = customFocus.getCustomFocus()) == null) continue;
            tree.addFirst(focused);
        }
        return tree;
    }

    protected final Optional<class_339> getWidget(class_2561 message) {
        return this.screen.method_25396().stream().filter(child -> child instanceof class_339).map(class_339.class::cast).filter(widget -> widget.method_25369().equals((Object)message)).findAny();
    }

    protected final Optional<class_339> getWidget(String translationKey) {
        String translatedName = class_2561.method_43471((String)translationKey).getString();
        return this.screen.method_25396().stream().filter(child -> child instanceof class_339).map(class_339.class::cast).filter(widget -> widget.method_25369().getString().equals(translatedName)).findAny();
    }

    public static void playClackSound() {
        minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public static void playFocusChangeSound() {
        minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ControlifyClientSounds.SCREEN_FOCUS_CHANGE.get(), (float)1.0f));
    }
}

