/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.keyboard;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.keyboard.InputTarget;
import dev.isxander.controlify.screenop.keyboard.KeyWidget;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayout;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayoutWithId;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.render.Blit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyboardWidget
extends class_339
implements class_4069,
ComponentProcessor {
    private class_2960 currentLayout;
    @Nullable
    private class_2960 previousLayout;
    private InputTarget inputConsumer;
    private List<KeyWidget> keys = ImmutableList.of();
    private boolean shifted;
    private boolean shiftLocked;
    @Nullable
    private KeyWidget focused;
    private boolean isDragging;
    private final HoldRepeatHelper fwdCursorHelper = new HoldRepeatHelper(10, 2);
    private final HoldRepeatHelper bwdCursorHelper = new HoldRepeatHelper(10, 2);

    public KeyboardWidget(int x, int y, int width, int height, KeyboardLayoutWithId layout, InputTarget inputConsumer) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"On-Screen Keyboard"));
        this.inputConsumer = inputConsumer;
        this.updateLayout(layout, "initial_focus", null);
    }

    public void updateLayout(KeyboardLayoutWithId layout) {
        class_2960 oldLayoutId = this.getCurrentLayoutId();
        @Nullable String oldResourceLocation = Optional.ofNullable(this.getFocused()).map(k -> k.getKey().identifier()).orElse(null);
        this.updateLayout(layout, oldResourceLocation, oldLayoutId);
    }

    public void updateLayout(KeyboardLayoutWithId layout, @Nullable String identifierToFocus, @Nullable class_2960 oldLayoutChangerToFocus) {
        this.previousLayout = this.currentLayout;
        this.currentLayout = layout.id();
        this.arrangeKeys(layout.layout());
        this.findKey(identifierToFocus != null, k -> Objects.equals(k.getKey().identifier(), identifierToFocus)).or(() -> this.findKey(oldLayoutChangerToFocus != null, k -> {
            KeyboardLayout.KeyFunction.SpecialFunc specialFunc;
            KeyboardLayout.KeyFunction.ChangeLayoutFunc changeLayoutKey;
            KeyboardLayout.KeyFunction patt0$temp = k.getKeyFunction();
            boolean isOldLayout = patt0$temp instanceof KeyboardLayout.KeyFunction.ChangeLayoutFunc && (changeLayoutKey = (KeyboardLayout.KeyFunction.ChangeLayoutFunc)patt0$temp).layout().equals((Object)oldLayoutChangerToFocus);
            KeyboardLayout.KeyFunction patt0$temp2 = k.getKeyFunction();
            boolean isPrevLayout = patt0$temp2 instanceof KeyboardLayout.KeyFunction.SpecialFunc && (specialFunc = (KeyboardLayout.KeyFunction.SpecialFunc)patt0$temp2).action() == KeyboardLayout.KeyFunction.SpecialFunc.Action.PREVIOUS_LAYOUT;
            return isOldLayout || isPrevLayout;
        }));
    }

    private void arrangeKeys(KeyboardLayout layout) {
        int keyCount = layout.keys().stream().mapToInt(List::size).sum();
        this.keys = new ArrayList<KeyWidget>(keyCount);
        float unitWidth = (float)this.method_25368() / layout.width();
        float keyHeight = (float)this.method_25364() / (float)layout.keys().size();
        int renderScale = class_3532.method_15375((float)Math.max(0.0f, Math.min(unitWidth, keyHeight) / 60.0f)) + 1;
        float y = this.method_46427();
        for (List<KeyboardLayout.Key> row : layout.keys()) {
            float x = this.method_46426();
            for (KeyboardLayout.Key key : row) {
                float keyWidth = key.width() * unitWidth;
                KeyWidget keyWidget = new KeyWidget((int)x, (int)y, (int)keyWidth, (int)keyHeight, renderScale, key, this);
                this.keys.add(keyWidget);
                x += keyWidth;
            }
            y += keyHeight;
        }
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (KeyWidget key : this.keys) {
            key.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        Blit.batchDraw(guiGraphics, () -> {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), Integer.MIN_VALUE);
            guiGraphics.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -5592406);
            for (KeyWidget key : this.keys) {
                key.renderKeyBackground(guiGraphics, mouseX, mouseY, partialTick);
            }
            for (KeyWidget key : this.keys) {
                key.renderKeyForeground(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
    }

    @Override
    public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
        InputTarget inputTarget = this.getInputTarget();
        GenericControllerConfig config = controller.genericConfig().config();
        if (inputTarget.supportsCursorMovement()) {
            if (this.fwdCursorHelper.shouldAction(ControlifyBindings.GUI_NEXT_TAB.on(controller)) && inputTarget.moveCursor(1)) {
                ScreenProcessor.playFocusChangeSound();
                this.fwdCursorHelper.onNavigate();
                this.bwdCursorHelper.reset();
                if (config.hintKeyboardCursor && config.showScreenGuides) {
                    config.hintKeyboardCursor = false;
                    Controlify.instance().config().save();
                }
                return true;
            }
            if (this.bwdCursorHelper.shouldAction(ControlifyBindings.GUI_PREV_TAB.on(controller)) && inputTarget.moveCursor(-1)) {
                ScreenProcessor.playFocusChangeSound();
                this.bwdCursorHelper.onNavigate();
                this.fwdCursorHelper.reset();
                if (config.hintKeyboardCursor && config.showScreenGuides) {
                    config.hintKeyboardCursor = false;
                    Controlify.instance().config().save();
                }
                return true;
            }
        }
        this.keys.forEach(k -> k.onControllerInput(controller));
        return ControlifyBindings.GUI_PRESS.on(controller).guiPressed().get();
    }

    public void setShifted(boolean shifted) {
        this.shifted = shifted;
    }

    public boolean isShifted() {
        return this.shifted;
    }

    public void setShiftLocked(boolean shiftLocked) {
        this.shiftLocked = shiftLocked;
    }

    public boolean isShiftLocked() {
        return this.shiftLocked;
    }

    public void setInputTarget(InputTarget inputConsumer) {
        this.inputConsumer = inputConsumer;
    }

    public InputTarget getInputTarget() {
        return this.inputConsumer;
    }

    public class_2960 getCurrentLayoutId() {
        return this.currentLayout;
    }

    public Optional<class_2960> getPreviousLayoutId() {
        return Optional.ofNullable(this.previousLayout);
    }

    private Optional<KeyWidget> findKey(boolean skipSearch, Predicate<KeyWidget> predicate) {
        if (skipSearch) {
            return Optional.empty();
        }
        return this.keys.stream().filter(predicate).findFirst();
    }

    @NotNull
    public List<KeyWidget> method_25396() {
        return Collections.unmodifiableList(this.keys);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public boolean method_25397() {
        return this.isDragging;
    }

    public void method_25398(boolean dragging) {
        this.isDragging = dragging;
    }

    @Nullable
    public KeyWidget getFocused() {
        return this.focused;
    }

    public void method_25395(@Nullable class_364 focused) {
        if (focused != null) {
            if (!(focused instanceof KeyWidget)) {
                throw new IllegalArgumentException("Focused widget must be a KeyWidget in this KeyboardWidget");
            }
            if (!this.keys.contains(focused)) {
                focused = null;
            }
        }
        if (this.focused != null) {
            this.focused.method_25365(false);
        }
        if (focused != null) {
            focused.method_25365(true);
        }
        this.focused = (KeyWidget)focused;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        return super.method_48205(event);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25370() {
        return super.method_25370();
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
    }
}

