/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public record SetCodec<E>(Codec<E> elementCodec, int minSize, int maxSize) implements Codec<Set<E>>
{
    private <R> DataResult<R> createTooShortError(int size) {
        return DataResult.error(() -> "Set is too short: " + size + ", expected range [" + this.minSize + "-" + this.maxSize + "]");
    }

    private <R> DataResult<R> createTooLongError(int size) {
        return DataResult.error(() -> "Set is too long: " + size + ", expected range [" + this.minSize + "-" + this.maxSize + "]");
    }

    private <R> DataResult<R> createDuplicatesError() {
        return DataResult.error(() -> "Set contains duplicate elements");
    }

    public <T> DataResult<T> encode(Set<E> input, DynamicOps<T> ops, T prefix) {
        if (input.size() < this.minSize) {
            return this.createTooShortError(input.size());
        }
        if (input.size() > this.maxSize) {
            return this.createTooLongError(input.size());
        }
        ListBuilder builder = ops.listBuilder();
        for (E element : input) {
            builder.add(this.elementCodec.encodeStart(ops, element));
        }
        return builder.build(prefix);
    }

    public <T> DataResult<Pair<Set<E>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            DecoderState decoder = new DecoderState(ops);
            stream.accept(decoder::accept);
            return decoder.build();
        });
    }

    @Override
    @NotNull
    public String toString() {
        return "SetCodec[" + String.valueOf(this.elementCodec) + "]";
    }

    private class DecoderState<T> {
        private static final DataResult<Unit> INITIAL_RESULT = DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable());
        private final DynamicOps<T> ops;
        private final Set<E> elements = new LinkedHashSet();
        private final Stream.Builder<T> failed = Stream.builder();
        private DataResult<Unit> result = INITIAL_RESULT;
        private int totalCount;

        private DecoderState(DynamicOps<T> ops) {
            this.ops = ops;
        }

        public void accept(T value) {
            ++this.totalCount;
            if (this.elements.size() >= SetCodec.this.maxSize) {
                this.failed.add(value);
                return;
            }
            DataResult elementResult = SetCodec.this.elementCodec.decode(this.ops, value);
            elementResult.error().ifPresent(error -> this.failed.add(value));
            int oldSize = this.elements.size();
            elementResult.resultOrPartial().ifPresent(pair -> this.elements.add(pair.getFirst()));
            if (this.elements.size() == oldSize) {
                this.failed.add(value);
                this.result = SetCodec.this.createDuplicatesError();
                return;
            }
            this.result = this.result.apply2stable((result, element) -> result, elementResult);
        }

        public DataResult<Pair<Set<E>, T>> build() {
            if (this.elements.size() < SetCodec.this.minSize) {
                return SetCodec.this.createTooShortError(this.elements.size());
            }
            Object errors = this.ops.createList(this.failed.build());
            Pair pair = Pair.of(Set.copyOf(this.elements), (Object)errors);
            if (this.totalCount > SetCodec.this.maxSize) {
                this.result = SetCodec.this.createTooLongError(this.totalCount);
            }
            return this.result.map(ignored -> pair).setPartial((Object)pair);
        }
    }
}

